using UnityEditor;
using UnityEngine;
using System.Collections.Generic;
using Unity.VisualScripting;

namespace StateMachine
{
    [CustomEditor(typeof(StateMachine))]
    [CanEditMultipleObjects]
    public class StateMachineEditor : Editor
    {
        SerializedProperty container;
        SerializedProperty states;
        SerializedProperty choser;

        public override void OnInspectorGUI()
        {
            container = serializedObject.FindProperty("container");
            states = serializedObject.FindProperty("states");
            choser = serializedObject.FindProperty("choser");

            serializedObject.Update();
            EditorGUILayout.PropertyField(container);

            int arrayLength = states.arraySize;


            EditorGUILayout.BeginHorizontal();

            EditorGUILayout.LabelField(new GUIContent("States"));

            bool isAdd = GUILayout.Button(new GUIContent("Add"));
            bool isRemove = GUILayout.Button(new GUIContent("Remove"));

            if (isAdd)
            {
                states.InsertArrayElementAtIndex(arrayLength);
                states.GetArrayElementAtIndex(arrayLength).objectReferenceValue = CreateInstance<State>();

                arrayLength = states.arraySize;
            }

            if (isRemove)
            {
                states.DeleteArrayElementAtIndex(0);

                arrayLength = states.arraySize;
            }

            EditorGUILayout.EndHorizontal();

            EditorGUILayout.Space(20);

            EditorGUILayout.BeginHorizontal();

            int screenWidth = Screen.width;
            screenWidth -= 300;

            GUILayout.Label("Name", GUILayout.MinWidth(300), GUILayout.MaxWidth(300));
            GUILayout.Label("Conditioner", GUILayout.MinWidth(screenWidth / 2 - 15), GUILayout.MaxWidth(screenWidth / 2 - 15));
            GUILayout.Label("Executer");

            EditorGUILayout.EndHorizontal();

            //states.Next(false);

            //states.Next(false);
            for (int i = 0; i < arrayLength; i++)
            {
                SerializedProperty p = states.GetArrayElementAtIndex(i);

                if (p.objectReferenceValue != null)
                {
                    SerializedObject o = new SerializedObject(p.objectReferenceValue);

                    o.Update();

                    SerializedProperty conditioner = o.FindProperty("conditioner");
                    SerializedProperty executer = o.FindProperty("executer");
                    SerializedProperty name = o.FindProperty("name");

                    EditorGUILayout.BeginHorizontal();

                    EditorGUILayout.PropertyField(name, GUIContent.none, GUILayout.MinWidth(300), GUILayout.MaxWidth(300));
                    EditorGUILayout.PropertyField(conditioner, GUIContent.none);
                    EditorGUILayout.PropertyField(executer, GUIContent.none);

                    EditorGUILayout.EndHorizontal();

                    o.ApplyModifiedProperties();
                }
            }

            EditorGUILayout.Space(20);

            EditorGUILayout.PropertyField(choser);

            serializedObject.ApplyModifiedProperties();
        }
    }
}
